#ifndef CTRANSFORM_H
#define CTRANSFORM_H
enum Axis {
            xAxis,
            yAxis,
            zAxis
        };
class CTransform {
    public:
        static const int DIMENSION = 4;
        

        CTransform ();
        ~CTransform();
        void rotate (Axis, float);
        void translate (Axis, float);
        void scale (Axis, float);
        float* transform (float*);

    private:
        float mat[DIMENSION][DIMENSION];

        //multipliziert mat mit einer Transformationsmatrix von links,
        //sodass die Reihenfolge der transform-Aufrufe der Reihenfolge der
        //tatsaechlichen Transformationen entspricht
        void updateMat(float transMatrix[][DIMENSION]);
};

#endif // CTRANSFORM_H
